package com.vmware.samples.chassisui.views.wizardPages {

import com.vmware.samples.chassisui.model.ChassisInfo;
import com.vmware.widgets.controls.wizardclasses.PageInfo;
import com.vmware.widgets.controls.wizardclasses.PageState;
import com.vmware.widgets.controls.wizardclasses.WizardPageMediator;

/**
 * The mediator for the DimensionsPage view. It extends the WizardPageMediator which gives it
 * the needed functions to easily integrate with the ChassisWizard.
 *
 */
public class DimensionsPageMediator extends WizardPageMediator {

   // The view that this mediator controls.
   private var _view:DimensionsPage;
   private var _pageInfo:PageInfo;

   [InjectableView]
   /**
    * The NameChassisPage view associated with this mediator.
    */
   public function set view(value:DimensionsPage):void {
      _view = value;
   }

   /** @private */
   public function get view():DimensionsPage {
      return _view;
   }

   /**
    * Data model inherited from the wizard.
    */
   private var _data:ChassisInfo;

   [Inherited]
   public function set data(value:ChassisInfo):void {
      if (_data != value) {
         _data = value;
      }
      if (_view != null && value != null) {
         // initialize text fields
         _view.chassisInfo = value;
      }
   }

   /** @private */
   public function get data():ChassisInfo {
      return _data;
   }

   override public function activate():void {
      // Nothing special to initialize in this page
      this.pageInfo.initialized = true;
   }

   /**
    * Override the pageInfo method to implement the commit function that
    * is called whenever the "Next" button is clicked.
    */
   override public function set pageInfo(value:PageInfo):void {
      super.pageInfo = value;

      if (pageInfo != null) {
         pageInfo.commitFunction = onPageCommit;
      }
   }

   /**
    * Commit function called when "Next" is clicked.
    * Performs validation of user input and allows to move to the next page.
    */
   private function onPageCommit(
         pageInfo:PageInfo,
         callback:Function,
         callbackContext:Object):void {

      // Read the form data but not validation necessary since dimensions are optional
      // Also set the page state to complete otherwise the wizard cannot be finished
      _data.dimensions = _view.chassisDimension.text;
      changeState(PageState.COMPLETE);

      // Always allow user to move to the next page
      callback(pageInfo, true, callbackContext);
   }

}
}